/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Galileo EV96100 setup.
 *
 * Copyright 2000 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *         	ppopov@mvista.com or source@mvista.com
 *
 * This file was derived from Carsten Langgaard's 
 * arch/mips/mips-boards/atlas/atlas_setup.c.
 *
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/mc146818rtc.h>
#include <linux/string.h>
#include <linux/ctype.h>

#include <asm/cpu.h>
#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/irq.h>
#include <asm/gt64120.h>
#include <asm/galileo-boards/ev96100.h>
#include <asm/galileo-boards/ev96100int.h>


void (*__wbflush) (void);

#if defined(CONFIG_SERIAL_CONSOLE) || defined(CONFIG_PROM_CONSOLE)
extern void console_setup(char *, int *);
char serial_console[20];
#endif

#ifdef CONFIG_REMOTE_DEBUG
extern void breakpoint(void);
int ev96100_remote_debug;
int ev96100_remote_debug_line;
#endif

void (*board_time_init)(struct irqaction *irq);
extern void ev96100_time_init(struct irqaction *irq);
extern char * __init prom_getcmdline(void);

extern void mips_reboot_setup(void);
extern struct rtc_ops no_rtc_ops;
extern struct resource ioport_resource;

void rm7000_wbflush()
{
    __asm__ __volatile__ ("sync");
}

unsigned char mac_0_1[12];

void __init ev96100_setup(void)
{

	unsigned long config = read_32bit_cp0_register(CP0_CONFIG);
	unsigned long status = read_32bit_cp0_register(CP0_STATUS);
	unsigned long info = read_32bit_cp0_register(CP0_INFO);

	char *argptr;

	set_cp0_status(ST0_FR,0);
        __wbflush = rm7000_wbflush;


        if (config & 0x8) {
            printk("Secondary cache is enabled\n");
        }
        else {
            printk("Secondary cache is disabled\n");
        }

        if (status & (1<<27)) {
            printk("User-mode cache ops enabled\n");
        }
        else {
            printk("User-mode cache ops disabled\n");
        }

        printk("CP0 info reg: %x\n", (unsigned)info);
        if (info & (1<<28)) {
            printk("burst mode Scache RAMS\n");
        }
        else {
            printk("pipelined Scache RAMS\n");
        }

        if ((info & (0x3<<26)) >> 26 == 0) {
            printk("67 percent drive strength\n");
        }
        else if ((info & (0x3<<26)) >> 26 == 1) {
            printk("50 percent drive strength\n");
        }
        else if ((info & (0x3<<26)) >> 26 == 2) {
            printk("100 percent drive strength\n");
        }
        else if ((info & (0x3<<26)) >> 26 == 3) {
            printk("83 percent drive strength\n");
        }


        if ((info & (0x3<<23)) >> 23 == 0) {
            printk("Write Protocol: R4000 compatible\n");
        }
        else if ((info & (0x3<<23)) >> 23 == 1) {
            printk("Write Protocol: Reserved\n");
        }
        else if ((info & (0x3<<23)) >> 23 == 2) {
            printk("Write Protocol: Pipelined\n");
        }
        else if ((info & (0x3<<23)) >> 23 == 3) {
            printk("Write Protocol: Write re-issue\n");
        }

        if (info & 0x1) {
            printk("Atomic Enable is set\n");
        }

	argptr = prom_getcmdline();
#ifdef CONFIG_SERIAL_CONSOLE
	if (strstr(argptr, "console=") == NULL) {
		argptr = prom_getcmdline();
		strcat(argptr, " console=ttyS0,115200");
	}
#endif	  


#ifdef CONFIG_REMOTE_DEBUG
	if (strstr(argptr, "kgdb=ttyS") != NULL) {
		int line;
		argptr += strlen("kgdb=ttyS");
		if (*argptr == '0')
			ev96100_remote_debug_line = 0;
		else if (*argptr == '1')
			ev96100_remote_debug_line = 1;
		else
			puts("Unknown serial line /dev/ttyS%c\n", *argptr);

		debugInitUart(ev96100_remote_debug_line);
		ev96100_remote_debug = 1;
		/* Breakpoints and stuff are in init_IRQ() */
	}
#endif

	board_time_init = ev96100_time_init;
	rtc_ops = &no_rtc_ops;
	mips_reboot_setup();
	mips_io_port_base = KSEG1;
	ioport_resource.start = GT_PCI_IO_BASE;
	ioport_resource.end   = GT_PCI_IO_BASE + 0x01ffffff;

#ifdef CONFIG_BLK_DEV_INITRD
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
#endif
}
