/*
 * include/asm/arch/serial_reg.h
 *
 * Redistribution of this file is permitted under the terms of the GNU 
 * Public License (GPL)
 * 
 * These are the SA1100 UART port assignments, expressed as long index 
 * of the base address.
 */

#ifndef ASM_ARCH_SERIAL_REG_H
#define ASM_ARCH_SERIAL_REG_H


/*
 * Register index.
 */
#define UTCR0 		0	/* 0x00 UART_LCR  Line control register */
#define UTCR1 		1	/* 0x04 UART_DLLSB */
#define UTCR2 		2	/* 0x08 UART_DLMSB */
#define UTCR3 		3	/* 0x0c UART_IER */
#define UTDR 		5	/* 0x14 UART_RX, UART_TX */
#define UTSR0 		7	/* 0x1c */
#define UTSR1 		8	/* 0x20 UART_LSR  Line Status register */

#define UART_RX 	UTDR		/* Receive port, read only */
#define UART_TX 	UTDR		/* transmit port, write only */


#endif /* ASM_ARCH_SERIAL_REG_H */
