/*
 * include/asm-parisc/cache.h
 */

#ifndef __ARCH_PARISC_CACHE_H
#define __ARCH_PARISC_CACHE_H

#if defined(__LP64__)
#define L1_CACHE_BYTES 64
#else
#define L1_CACHE_BYTES 32
#endif

#define L1_CACHE_ALIGN(x)       (((x)+(L1_CACHE_BYTES-1))&~(L1_CACHE_BYTES-1))

#define SMP_CACHE_BYTES L1_CACHE_BYTES

#define __cacheline_aligned __attribute__((__aligned__(L1_CACHE_BYTES)))

extern void init_cache(void);		/* initializes cache-flushing */
extern void flush_data_cache(void);	/* flushes data-cache only */
extern void flush_instruction_cache(void);/* flushes code-cache only */
extern void flush_all_caches(void);	/* flushes code and data-cache */

extern int get_cache_info(char *);

extern struct pdc_cache_info cache_info;

#define fdce(addr) asm volatile("fdce 0(%0)" : : "r" (addr))
#define fice(addr) asm volatile("fice 0(%%sr1,%0)" : : "r" (addr))

#define pdtlbe(addr) asm volatile("pdtlbe 0(%%sr1,%0)" : : "r" (addr))
#define pdtlb_kernel(addr)  asm volatile("pdtlb 0(%0)" : : "r" (addr));
#define pitlbe(addr) asm volatile("pitlbe 0(%%sr1,%0)" : : "r" (addr))

#define kernel_fdc(addr) asm volatile("fdc 0(%%sr0, %0)" : : "r" (addr))

#endif
