
/* $Id: sysdep-2.2.h,v 1.1.1.1 2001/05/10 18:02:56 noname Exp $ 
 * centralize the changes for kernel 2.0,2.1 and 2.2
*/

#ifndef _SYSDEP_22_H_
#define _SYSDEP_22_H_

#include "sysdep-2.1.h"

#ifndef KERNEL_VERSION
#  define KERNEL_VERSION(a,b,c) VERSION_CODE(a,b,c)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,0)

#  define __init
#  define __initdata
#  define __initfunc(func) func

// for now, to make it compilable
#define __constant_cpu_to_le16(x) x

typedef struct wait_queue * wait_queue_head_t;

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#define DECLARE_WAITQUEUE(x,y) struct wait_queue x = {y,NULL}
#define DECLARE_WAIT_QUEUE_HEAD(x) struct wait_queue *x = NULL
#define init_waitqueue_head init_waitqueue

#define DECLARE_MUTEX(x) struct semaphore x = MUTEX;
#endif

// from 2.2, linux/types.h
#ifndef __BIT_TYPES_DEFINED__
#define __BIT_TYPES_DEFINED__

typedef         __u8            u_int8_t;
typedef         __s8            int8_t;
typedef         __u16           u_int16_t;
typedef         __s16           int16_t;
typedef         __u32           u_int32_t;
typedef         __s32           int32_t;

#endif /* !(__BIT_TYPES_DEFINED__) */

// hack for missing atomic instr.
#define atomic_set(x,y) *(x)=y 
#define atomic_read(x) *(x)

#endif	// LINUX_VERSION_CODE < KERNEL_VERSION(2,2,0)

// return types for module init/cleanup 
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
  #define mod_init_t int  __init
  #define mod_exit_t void  
#else
  #define mod_init_t static int __init
  #define mod_exit_t static void __exit
#endif

#endif	// _SYSDEP_22_H_

